 /***************************************************
 *
 *  DESCRIPTION: Atomic Model Base Station Processor
 *
 *  AUTHOR: Misagh Tavanpour
 *
 *  DATE: 25/10/2012
 *
 ****************************************************/

 #ifndef __BSprocessor4_H
 #define __BSprocessor4_H

 #include "atomic.h"      // class Atomic
 #include "string.h"	  // class String

 class BSprocessor4 : public Atomic
 {
   public:
	       BSprocessor4 ( const std::string &name = "BSprocessor4" );  //Default constructor
	       virtual std::string className() const {  return "BSprocessor4" ;}
	       ~BSprocessor4();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        const Port &In;
	        Port &OB0,&OB1,&OB2,&OB3,&OB5,&OB6,&OU2,&Req;
	        Time ProcessTime;
	        int Temp,i,j,CurrentCell;
	        int UEinBS [7][3];
	        int NextHop [10];
	        int Neighborhood [7];
	        int Digit [6];
	        int MyUEMode [3];
	        int Turn;
	        int BSMes1,BSMes2,BSMes1Port,BSMes2Port;
	        int UECoordinationSet [3][3];
	        int OutPort;
         	enum State{
			            Idle,
			            SetCSMode,
			            NormalMode,
			            InfoMode,
			            AskNewTask,
		              };
		    State state;
 };

#endif   //__BSprocessor4_H
